/*
 * Decompiled with CFR 0.152.
 */
package bmv.multicast.conexion;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;

public class ClienteSocket
implements Runnable {
    private String ip;
    private int port;
    private String networkInterface;
    private boolean activeSocket = Boolean.TRUE;
    private LinkedBlockingQueue<byte[]> queue;

    public ClienteSocket(String ip, int port, String networkInterface) {
        this.ip = ip;
        this.port = port;
        this.networkInterface = networkInterface;
    }

    @Override
    public void run() {
        try {
            MulticastSocket cliente = new MulticastSocket(this.port);
            InetSocketAddress mcastAddr = new InetSocketAddress(this.ip, this.port);
            NetworkInterface netif = NetworkInterface.getByName(this.networkInterface);
            cliente.joinGroup(mcastAddr, netif);
            System.out.println("\nServer: " + this.ip + ", port: " + this.port + ", networkInterface: " + this.networkInterface);
            short siguienteLectura = 0;
            byte[] testArray = new byte[cliente.getReceiveBufferSize()];
            try {
                do {
                    System.out.println("###########################");
                    DatagramPacket dgramTest = new DatagramPacket(testArray, testArray.length, mcastAddr);
                    cliente.receive(dgramTest);
                    testArray = dgramTest.getData();
                    siguienteLectura = this.getShort(testArray);
                    System.out.println("tamanioEsperado:" + siguienteLectura);
                    byte[] respuesta = new byte[siguienteLectura];
                    System.arraycopy(testArray, 0, respuesta, 0, siguienteLectura);
                    System.out.println("tamanioLeido:" + respuesta.length);
                    this.queue.put(respuesta);
                    System.out.println("=====================");
                } while (this.activeSocket);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Cerrando conexi\u00f3n...");
            cliente.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private short getShort(byte[] arreglo) {
        return ByteBuffer.wrap(arreglo).getShort();
    }

    public final LinkedBlockingQueue<byte[]> getQueue() {
        return this.queue;
    }

    public final void setQueue(LinkedBlockingQueue<byte[]> queue) {
        this.queue = queue;
    }

    public final boolean isActiveSocket() {
        return this.activeSocket;
    }

    public final void setActiveSocket(boolean activeSocket) {
        this.activeSocket = activeSocket;
    }
}

